<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\Mdata;
class Utama extends Controller
{
    public function statusAPI(){
        $dtrespon = ["kode"=>"01", "status"=>"API berjalan dengan baik"];
        return response()->json($dtrespon, 200);
    }

    public function backupData(Request $request)
{
    $nama = $request->input("nama_backup"); // harus 'nama_backup' karena yang dikirim dari ajax tadi 'nama_backup'
    $dtx = base64_decode($request->input("dtx"));
    $id  = floor(microtime(true) * 1000); // id backup (timestamp)

    if (!$nama) {
        return response()->json([
            "kode"  => "0",
            "pesan" => "Nama Backup tidak boleh kosong"
        ]);
    }

    $mx = new Mdata();
    $proses = $mx->TambahBackup($id, $nama); // insert ke tabel backup

    if ($proses != "1") {
        return response()->json([
            "kode"  => "0",
            "pesan" => "Proses Backup Gagal"
        ]);
    }

    $data_transaksi = json_decode($dtx, true);
    $berhasil = 0;
    $gagal = 0;

    foreach ($data_transaksi as $item) {
        try {
            $proses2 = $mx->TambahTransaksi(
                $item['id'],      // id transaksi
                $id,              // id_backup
                $item['tgl_jam'], // tgl_jam
                $item['nominal'], // nominal
                $item['jenis'],   // jenis
                $item['uraian']   // uraian
            );

            if ($proses2 == "1") {
                $berhasil++;
            } else {
                $gagal++;
            }
        } catch (\Exception $e) {
            Log::error("Error Backup Transaksi: " . $e->getMessage());
            $gagal++;
        }
    }

    return response()->json([
        "kode"     => "1",
        "pesan"    => "Proses Backup Berhasil",
        "berhasil" => $berhasil,
        "gagal"    => $gagal
    ]);
}

public function backupDataFile(Request $request)
{
    $nama = $request->input("nama_backup");
    $dtx  = base64_decode($request->input("dtx"));

    if (!$nama) {
        return response()->json([
            "kode"  => "0",
            "pesan" => "Nama Backup tidak boleh kosong"
        ]);
    }

    $filename = time() . '_' . preg_replace('/[^A-Za-z0-9\-]/', '_', $nama) . '.json';
    $path = public_path("backup/" . $filename);

    file_put_contents($path, $dtx);

    return response()->json([
        "kode"    => "1",
        "pesan"   => "Backup file berhasil",
        "file"    => $filename,
        "url"     => asset("backup/" . $filename)
    ]);
}

public function listBackupFiles()
{
    $files = glob(public_path("backup/*.json"));

    $fileNames = array_map(function ($file) {
        return basename($file);
    }, $files);

    return response()->json([
        "kode" => "1",
        "data" => $fileNames
    ]);
}

public function downloadBackupFile($filename)
{
    $path = public_path("backup/" . $filename);

    if (!file_exists($path)) {
        return response()->json([
            "kode"  => "0",
            "pesan" => "File tidak ditemukan"
        ]);
    }

    $content = file_get_contents($path);
    $encoded = base64_encode($content);

    return response()->json([
        "kode" => "1",
        "data" => $encoded
    ]);
}




}